/********************
>>> EXEMPLE 17-25 <<<
********************/

USE DB_FRAG;
GO
-- Cration dune table avec diverses colonnes
CREATE TABLE T2 
(K     INT IDENTITY,
 GID   UNIQUEIDENTIFIER,
 C     CHAR(780));
GO

-- Boucle dinsertion de donnes alatoires
INSERT INTO T2
SELECT NEWID(), REPLICATE(CHAR(CAST(FLOOR((RAND() * 223) + 32) AS INT)), 780);
GO 1000

-- Ajout des contraintes de cl primaire et dunicit
ALTER TABLE T2 ADD
   CONSTRAINT PK2 PRIMARY KEY (K),
   CONSTRAINT UK2 UNIQUE (GID);
GO

-- Cration dun index sur cette table
CREATE INDEX X2 ON T2 (C);
GO

-- Dmarrage dune transaction supprimant 200 lignes pioches rgulirement
BEGIN TRANSACTION TRN_DELETE;
DELETE FROM T2 
WHERE K % 5 = 3;

/********************
>>> EXEMPLE 17-26 <<<
********************/

--> NOTA Cette commande doit tre excute dans la mme fentre que celle utilise pour lexemple 17-25 et avec la transaction tioujours ouverte
DBCC IND ('DB_FRAG', 'dbo.T2', -1);
--> ATTENTION : le n de page peut varier an fonction de votre version de SQL Server et des manipulations efectues prcdemment

/********************
>>> EXEMPLE 17-27 <<<
********************/
DBCC PAGE ('DB_FRAG', 1, 540, 1) WITH TABLERESULTS;

-- COMMIT TRANSACTION TRN_DELETE;

